clc; clear; close all
savefilename = mfilename;
%%
main = '10'; td2 = 21;

fl = 11:1:11+(td2-1);
addpath('/Users/jihyunkim/Google Drive/LAB/postdoc_wis/Data_wis/bruker600/2020-10-11_RNA_test');%rbnmr location

for i = 1:length(fl)
    path = ['/Users/jihyunkim/Google Drive/LAB/postdoc_wis/Data_wis/1GHz/2020-10-19_SL8_283K/' main '/pdata/' num2str(fl(i))]; %data location
    A = rbnmr([path]);
    dta(:,i) = A.Data;
    ppm(:,1) = A.XAxis;
end

% plot series of 1D

figure(1)
subplot(121)
plot(ppm,dta);hold on;
xlim([5,15])

%% plot as 2D 

ysi = 200;
yppm = linspace(145,165,ysi); yppm = yppm'; 
xppm = ppm;

%% list of peaks
% copy from fq1list and fq3list

H = [13.3629
10.7971
13.7762
11.8786
11.1146
14.2373
12.4978
13.0449
11.4576
12.6962
12.8137
12.5543
12.803
14.0335
12.8632
10.9179
12.3598
12.3169
13.1634
10.3167
13.5162];

N = [161.4462
147.0339
162.2341
147.2631
158.6268
162.9265
147.4735
147.8356
146.0732
147.2401
149.0706
147.0964
148.2413
162.2754
161.9559
156.9032
147.0023
160.1892
148.3135
146.0739
161.5767];

%% reshape the data for 2D plot

matrix = zeros(size(dta,1),ysi);

for i = 1:length(N)
    [ d, ind ] = min(abs(yppm-N(i)));
    matrix(:,ind) = matrix(:,ind)+dta(:,i);
    clear ind
end
    
matrix = matrix';

% plot 2D
factor = 1.4;
level = 2.5e8;
xcal = 0; ycal = 0; %calibration
subplot(122)
contour(xppm+xcal,yppm+ycal,matrix,[level,level*factor,level*factor^2,level*factor^3,level*factor^4,level*factor^5,level*factor^6,level*factor^6,level*factor^7,level*factor^8],'black'); title('');
xlim([6,15])

set(gca,'Xdir','reverse','Ydir','reverse','yaxislocation','right'...
    ,'FontSize',14,'LineWidth',1,'Color','w','XMinorTick','on','YMinorTick','on');
set(gcf,'Color','w');
set(gcf,'Units','inche','Position', [0.3333 5.6528 12.4722 6.6389],'Color','w');
xlabel('^1H / ppm'); ylabel('^{15}N / ppm')


save(savefilename,'dta','xppm','yppm','xcal','ycal','matrix','level','factor','N')
